package gov.va.genisis2.util.rest.helper;

import java.io.Serializable;

import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlSeeAlso;

import org.apache.commons.lang3.StringUtils;

import gov.va.genisis2.model.CommentHistory;
import gov.va.genisis2.model.Request;
import gov.va.genisis2.model.StudyApproval;

/**
 * The Class ResponseWrapper.
 *
 * @author 586338
 */
@XmlRootElement
@XmlSeeAlso({ Request.class, StudyApproval.class, CommentHistory.class })
public class ResponseWrapper implements Serializable {

	/** The Constant serialVersionUID. */

	private static final long serialVersionUID = -41636551261146493L;

	/** The response. */
	private transient Object response;

	/** The message. */
	private String message;

	/** The success. */
	private Boolean success = true;

	/**
	 * Instantiates a new response wrapper.
	 */
	public ResponseWrapper() {
		this.response = null;
		this.message = StringUtils.EMPTY;
		this.success = false;
	}

	/**
	 * Gets the response.
	 *
	 * @return the response
	 */
	public Object getResponse() {
		return response;
	}

	/**
	 * Sets the response.
	 *
	 * @param response
	 *            the new response
	 */
	public void setResponse(Object response) {
		this.response = response;
	}

	/**
	 * Gets the message.
	 *
	 * @return the message
	 */
	public String getMessage() {
		return message;
	}

	/**
	 * Sets the message.
	 *
	 * @param message
	 *            the new message
	 */
	public void setMessage(String message) {
		this.message = message;
	}

	/**
	 * Gets the success.
	 *
	 * @return the success
	 */
	public Boolean getSuccess() {
		return success;
	}

	/**
	 * Sets the success.
	 *
	 * @param success
	 *            the new success
	 */
	public void setSuccess(Boolean success) {
		this.success = success;
	}

}
